﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using AZVIC.Ei8htPOS.Utilities;
using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using System.Text.RegularExpressions;
using System.Windows.Threading;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using AZVIC.Ei8htPOS.Entities;




namespace AZVIC.Ei8htPOS.POSRetail.Controls
{
    /// <summary>
    /// Interaction logic for CashPayment.xaml
    /// </summary>
    public partial class OpeningDayBalance : Window
    {
        public OpeningDayBalance()
        {
            InitializeComponent();
           
        }

        private void btnCancelPayment_Click(object sender, RoutedEventArgs e)
        {
            DialogResult = false;
            Close();
        }

        private void btnConfirmPayment_Click_1(object sender, RoutedEventArgs e)
        {

            if (Validate())
            {
                DialogResult = true;
                Close();
            }
        }

        private bool Validate()
        {
            bool Validated = true;
            if ((decimal.Parse(txtOpeningDayBalance.Text) != decimal.Parse(lblLastDayBalance.Text.Replace("$", ""))) && (string.IsNullOrEmpty(txtVarianceRemarks.Text.Trim())) )
            {
                App.ShowErrorMessageBox("Please enter remarks","Ei8ht POS");
                Validated = false;
            }
            return Validated;
        }

        private void txtAmountPaid_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.Enter)
            {
                btnConfirmPayment.Focus();
            }
            else if (e.Key == Key.Delete || e.Key == Key.Back || e.Key == Key.End || e.Key == Key.Home ||
                (e.Key >= Key.NumPad0 && e.Key <= Key.NumPad9) || (e.Key >= Key.D0 && e.Key <= Key.D9) || (e.Key == Key.Decimal) || (e.Key == Key.OemPeriod))
            {
                e.Handled = false;
            }
            else
                e.Handled = true;
        }


        public static string Prompt(string OpeningDayBalance="")
        {
            OpeningDayBalance inst = new OpeningDayBalance();
            inst.ResponseText = OpeningDayBalance;
            inst.lblLastDayBalance.Text = string.Format("{0:C}", OpeningDayBalance);
            inst.ShowDialog();
            if (inst.DialogResult == true)
                return inst.ResponseText;
            return null;
        }

        public string ResponseText
        {
            get
            {
                return txtOpeningDayBalance.Text.Trim().Replace("|","") + "|" + txtVarianceRemarks.Text.Trim().Replace("|","");
            }
            set
            {
                txtOpeningDayBalance.Text = value;
            }
        }
        
    }
}
